--[[
If you want to use this in your own StepMania theme, VNUtils is licensed under cc-by-nc 4.0
Contact me for commercial use, otherwise IF I SEE IT I WILL BE VERY ANGRY!!!!!!!!!!!!!!!!!!!!!!!

Audio doesn't work properly without fixes in Rave Paradise and will leak memory

https://creativecommons.org/licenses/by-nc/4.0/legalcode
]]

function GetVNBG(name)
	--Trace(THEME:GetPathG("","VNBackgrounds/"..name);
	return THEME:GetPathG("","VNBackgrounds/"..name);
end;

function GetVNBGActor(name,startHidden)
	return Def.Sprite{
		Texture=THEME:GetPathG("","VNBackgrounds/"..name);
		InitCommand=function(s) s:scaletocover(0,0,SCREEN_RIGHT,SCREEN_BOTTOM):diffusealpha(startHidden and 0 or 1) end;
	}
end;

function GetVNBGQuad(color,startHidden)
	return Def.Quad{
		InitCommand=function(s) s:setsize(SCREEN_WIDTH,SCREEN_HEIGHT):diffuse(color):diffusealpha(startHidden and 0 or 1):Center() end;
	}
end;


function genTextBackground(TEXTBOX_HEIGHT)
	if not TEXTBOX_HEIGHT then
		TEXTBOX_HEIGHT = 150;
	end
	
	return Def.ActorFrame{
		--InitCommand=cmd(xy,SCREEN_CENTER_X,SCREEN_HEIGHT*.85;vertalign,top;);

		--Textbox & lines
		Def.Quad{ --BG
			InitCommand=cmd(setsize,SCREEN_WIDTH,TEXTBOX_HEIGHT;diffuse,color("0,0,0,.8");fadeleft,.1;faderight,.1;zoomy,0);
			OnCommand=cmd(decelerate,.2;zoomy,1);
			PlayCommand=cmd(zoomy,0;decelerate,.2;zoomy,1);
			StopCommand=cmd(zoomy,1;decelerate,.2;zoomy,0;sleep,0);
		};
		Def.Quad{ --Top
			InitCommand=cmd(setsize,SCREEN_WIDTH,2;diffuse,Color("White");fadeleft,.1;faderight,.1;y,-(TEXTBOX_HEIGHT/2 - 10));
			PlayCommand=cmd(diffusealpha,0;decelerate,.2;diffusealpha,1);
			StopCommand=cmd(decelerate,.2;diffusealpha,0;sleep,0);
		};
		--[[Def.Quad{ --Bottom
			InitCommand=cmd(setsize,SCREEN_WIDTH*.25,2;diffuse,Color("White");fadeleft,.1;horizalign,left;addx,-(SCREEN_WIDTH*.50);addy,TEXTBOX_HEIGHT/2 - 10);
		};
		Def.Quad{ --Arrow left part
			InitCommand=cmd(setsize,2,100;diffuse,Color("White");horizalign,left;vertalign,top;x,SCREEN_WIDTH*.25;addx,-(SCREEN_WIDTH*.50)-2;addy,TEXTBOX_HEIGHT/2 - 10)
		};]]
		Def.Quad{ --Bottom
			InitCommand=cmd(setsize,SCREEN_WIDTH,2;diffuse,Color("White");fadeleft,.1;faderight,.1;y,TEXTBOX_HEIGHT/2 - 10);
			PlayCommand=cmd(diffusealpha,0;decelerate,.2;diffusealpha,1);
			StopCommand=cmd(decelerate,.2;diffusealpha,0;sleep,0);
		};
		
		--For debugging, left and right
		--[[Def.Quad{
			InitCommand=cmd(setsize,2,TEXTBOX_HEIGHT;diffuse,Color("Red");addx,-350);
		};
		Def.Quad{
			InitCommand=cmd(setsize,2,TEXTBOX_HEIGHT;diffuse,Color("Red");addx,350);
		};]]
		

		--[[LoadFont("Dialogue Character Names")..{
			Text="Reimu Hakurei";
			InitCommand=cmd(xy,-SCREEN_WIDTH/2+100,-TEXTBOX_HEIGHT/2 - 3;horizalign,left;vertalign,bottom;shadowcolor,Color("Black");shadowlength,1);
		};]]
	};

end

--Because it's better than adding the commands every time. Probably.
function Actor:VN_Dim()
	self:linear(.3):diffuse(color(".5,.5,.5,1"));
end;

function Actor:VN_Undim()
	self:linear(.3):diffuse(color("1,1,1,1"));
end;

function Actor:VN_Appear()
	self:sleep(.5):decelerate(.5):rotationy(0);
end;

function Actor:VN_Disappear()
	self:accelerate(.5):rotationy(90);
end;

function playSong(songName,diff,stepsType)
	if not stepsType then stepsType = "StepsType_Pump_Single" end;
	GAMESTATE:ApplyGameCommand('style,single;playmode,Regular;song,'..songName)
	local song = GAMESTATE:GetCurrentSong()
	if song then
		local steps = song:GetOneSteps(stepsType, diff);
		GAMESTATE:SetCurrentSteps(PLAYER_1,steps);
		local can, reason = GAMESTATE:CanSafelyEnterGameplay()
		if can then
			if STORYDATA.DEBUG_SKIP_SONG then
				SCREENMAN:SystemMessage("DEBUG_SKIP_SONG enabled, skipping... (Reload screen to continue)")
				return true;
			end;
			SCREENMAN:GetTopScreen():SetNextScreenName("ScreenPlayerOptionsStory");
			SCREENMAN:GetTopScreen():StartTransitioningScreen("SM_GoToNextScreen");
		else
			SCREENMAN:SystemMessage("Can't play the song! "..reason);
		end;
	else
		SCREENMAN:SystemMessage("Can't enter gameplay! No song is set!")
	end;
end;

function VNBackgrounds(backgrounds)
	local mt = {
		__index = {
			makeActorFrame=function(self)
				local bgFrame={
					Class='ActorFrame';
					Name="EventBGFrame";
					InitCommand=cmd(diffusealpha,1;SetDrawByZPosition,true);
					OnCommand=function(subself)
						self.ActorFrame = subself;
					end;
				}
				for i,v in ipairs(self.bgs) do
					bgFrame[i]=v;
					bgFrame[i].Name=i;
				end;
				return bgFrame;
			end;
			show=function(self,idx)
				self.ActorFrame:GetChild(idx):linear(.5):diffusealpha(1)
			end;
			hide=function(self,idx)
				self.ActorFrame:GetChild(idx):linear(.5):diffusealpha(0)
			end;
		}
	}
	return setmetatable({bgs=backgrounds}, mt)
end;

--It's the old class for left/right position
function VNTextPortrait(spriteToLoad)
	local mt = {
		__index = {
			make_actor=function(self)
				return Def.Sprite{
					Name=self.spr;
					Texture=THEME:GetPathB("StoryArea","overlay/"..self.spr);
					InitCommand=function(subself)
						self.actor = subself;
						(cmd(vertalign,bottom;y,SCREEN_BOTTOM+225;animate,false;diffusealpha,0;zoom,.4))(subself)
					end;
					StopCommand=function(subself)
						subself:stoptweening():decelerate(.2);
						subself:x(self.rightSide and SCREEN_RIGHT+150 or -150):diffusealpha(0)
						self.is_active = false
					end;
				};
			end,
			position_portrait = function(self,rightSide,offset,mask)
				self.is_active = true --Because dimming will make invisible portraits visible...
				if not offset then offset = 0 end;
				--assert(fileName)
				--self.actor:Load(THEME:GetPathB("StoryArea","overlay/"..fileName));
				self.actor:stoptweening():diffusealpha(1);
				
				self.rightSide = rightSide;
				local negOffset = rightSide and -1 or 1;
				--(cmd(stoptweening;diffusealpha,1;))(self.actor)
				self.actor:z(offset);
				
				if rightSide then
					self.actor:x(SCREEN_RIGHT+200);
					self.offset = SCREEN_RIGHT-150-offset*100;
				else
					self.actor:x(-200):rotationy(180);
					self.offset = 200+offset*100;
				end;
				--I forget why I'm storing this to be honest.
				self.actor:decelerate(.2):x(self.offset);
				--self.actor:Center();
				--Trace(self.offset)
			end
		}
	};
	return setmetatable({spr=spriteToLoad}, mt)
end;

--More 'VN' style, no left/right positioning support.

--local placement = SCREEN_WIDTH/(numChoices)*index-(SCREEN_WIDTH/numChoices/2)
--local xPosition = SCREEN_CENTER_X-sqWidth/2+bWidth/2+SSC_BORDER_SIZE/2;
local portraitPositions = {
	{SCREEN_CENTER_X},
	{SCREEN_CENTER_X-200,SCREEN_CENTER_X+200}, --separation of 200px
	{SCREEN_CENTER_X-200,SCREEN_CENTER_X,SCREEN_CENTER_X+200},
	{SCREEN_CENTER_X-300,SCREEN_CENTER_X-100,SCREEN_CENTER_X+100,SCREEN_CENTER_X+300}
}

function VNTextPortrait2(spriteToLoad)
	local MASK_BOX_Y_OFFSET = -100
	local mt = {
		__index = {
			make_actor=function(self)
				return Def.ActorFrame{
					InitCommand=function(subself)
						self.actor = subself;
						assert(self.actor);
						subself:diffusealpha(0);
					end;
					StopCommand=function(subself)
						subself:stoptweening():decelerate(.2);
						subself:addx(100):diffusealpha(0)
						self.is_active = false
						self.idx = -1
					end;
					
					
					--Mask part 1
					Def.Sprite{
						Texture=THEME:GetPathG("VN","maskBox1");
						InitCommand=function(sself)
							sself:xy(-6,10+MASK_BOX_Y_OFFSET);
							self.mbox1=sself;
						end;
						--Name="MaskSource";
						--InitCommand=
					};
					
					Def.Quad{
						Name="MaskSource";
						InitCommand=function(subself)
							self.quad = subself;
							subself:y(MASK_BOX_Y_OFFSET):zoomto(319/2,457/2):diffuse(1,1,1,1):visible(true):MaskSource()
							
						end;
					};
					
					Def.Sprite{
						Name=self.spr;
						Texture=THEME:GetPathG("","VNPortraits/"..self.spr);
						InitCommand=function(subself)
							self.sprActor = subself;
							
							--subself:GetParent():GetChild("MaskSource"):y(subself:GetY()-300)
						end;
					};
					
					Def.Sprite{
						Name="MaskBox2";
						Texture=THEME:GetPathG("VN","maskBox2");
						InitCommand=function(sself)
							sself:y(MASK_BOX_Y_OFFSET);
							self.mbox2 = sself;
						end;
					};
						
					--Mask part 2
					--[[Def.Quad{
						InitCommand=function(subself)
							self.quad = subself;
							subself:setsize(250,400):diffuse(color("#1e85c755")):vertalign(bottom):visible(true)
							
							subself:y(subself:GetParent():GetChild(self.spr):GetY()-300)
						end;
					};]]
					Def.Sprite{
						Texture=THEME:GetPathG("VN",'MaskOverlay');
						InitCommand=function(sself)
							self.maskOverlay = sself;
							sself:y(MASK_BOX_Y_OFFSET):blend(Blend.Add):texcoordvelocity(0,-0.2):diffusealpha(.8):zoomto(319/2,457/2);
						end;
					};
				}
			end,
			set_mask_visible = function(self,b)
				self.mbox1:visible(b);
				self.quad:visible(b);
				self.mbox2:visible(b);
				self.maskOverlay:visible(b);
				
			end;
			position_portrait = function(self,idx,isMasked,offset,numPortraits)
				--assert(self.actor)
				if not offset then offset = 0 else offset=offset*100 end;
				self.offset = offset;
				self.idx=idx; --Needed for dim/hl to function
				
				
				Trace("idx: "..idx.." numPortraits: "..numPortraits.. " offset: "..offset)
				if self.is_active then
					--Trace(portraitPositions[numPortraits][idx])
					--Trace(portraitPositions[numPortraits][idx]+self.offset)
					self.actor:stoptweening():decelerate(.4):x(portraitPositions[numPortraits][idx]+self.offset)
					return
				end;
				self.is_active = true --Because dimming will make invisible portraits visible...
				--assert(fileName)
				--self.actor:Load(THEME:GetPathB("StoryArea","overlay/"..fileName));
				self.actor:stoptweening():diffusealpha(0);
				
				self.actor:z(offset);
				
				
				
				assert(portraitPositions[numPortraits], "portraitPositions doesn't go up to "..numPortraits)
				assert(portraitPositions[numPortraits][idx])
				--self.actor:x(SCREEN_CENTER_X)
				
				--assert(type(isMasked)=='boolean')
				--self.quad:visible(isMasked);
				self:set_mask_visible(isMasked);
				if isMasked then
					--self.actor:zoomy(0);
					self.sprActor:ztestmode('ZTestMode_WriteOnFail');
				end;
				self.actor:y(isMasked and -100 or 0);
				self.actor:x(portraitPositions[numPortraits][idx]+self.offset+100):decelerate(.4):x(portraitPositions[numPortraits][idx]+self.offset):diffusealpha(1) --:zoomy(1);
				

				--self.actor:Center();
				--Trace(self.offset)
			end,
			reposition_portrait=function(self,idx,offset,numPortraits)
				self.idx=idx;
				self.actor:stoptweening():x(portraitPositions[numPortraits][idx]+self.offset);
			end;
		}
	};
	return setmetatable({spr=spriteToLoad}, mt)
end;

--What am I even doing?
--Should move ChoiceTable somewhere else... Oh well
--ChoiceTable = {};
function LoadVNText4(saveData,portraits,sound,backgrounds)
	ChoiceTable = nil; --It shouldn't persist between screens... It probably shouldn't even be a global variable
	
	local vntext_mt= {
__index= {
		
		--Note: The arguments are for resuming context. They are optional.
        make_actor= function(self, font, maxwidth, spd)
        	
			self.cur_len= 0
			self.spd= spd
			self.curIndex = 0;

			self.isPopup = false
			self.bg = nil;
			self.popup = nil; --I don't think this is actually necessary
			
			self.matchedNames={};
        	
            return Def.ActorFrame{
				genTextBackground(150)..{
					Name='TextBackground';
					InitCommand=function(subself)
						self.bg = subself
					end;
				};
				Def.Quad{
					Name="Popup";
					InitCommand=function(subself)
						--subself:diffuse({0,0,0,.8}):setsize(1,1):zoomtoheight(20);
						subself:diffuse({0,0,0,0}):zoomtoheight(0);
						self.popup = subself;
					end;
					--Play is a reserved command. We DON'T want this to activate normally.
					--Doesn't work, need to pass height anyways...
					AppearCommand=function(subself,h)
						subself:decelerate(.2):diffusealpha(.8):zoomtoheight(h or 20);
					end;
					StopCommand=function(subself)
						subself:decelerate(.2):zoomtoheight(0):diffusealpha(0);
					end;
				};
				Def.ActorMultiVertex{
					Name="NameBG";
					InitCommand=function(q)
						q:xy(-SCREEN_CENTER_X+130,-150/2-38):SetDrawState{Mode="DrawMode_QuadStrip"};
						q:SetVertices({
							{{0, 0, 0}, color("0,0,0,.8")},
							{{200-2, 0, 0}, color("0,0,0,.8")},
							{{0, 35, 0}, color("0,0,0,.8")},
							{{200+40, 35, 0}, color("0,0,0,.8")}
						})
					end;
				};
				LoadFont("Dialogue Character Names")..{
					Name="LeftName";
					InitCommand=function(subself)
						self.name_actor = subself
						--(cmd(xy,150,-150/2+5;addx,100;halign,0.2;vertalign,bottom;shadowcolor,Color.Black;diffusebottomedge,Color.Red;shadowlength,1;diffusealpha,0))(subself);
						subself:xy(-SCREEN_CENTER_X+250,-150/2-7):addx(100):halign(0.5):vertalign(bottom):shadowcolor(Color.Black):shadowlength(1):diffusealpha(0):diffusebottomedge(Color.White)
					end;
					OnCommand=function(subself,param)
						(cmd(decelerate,.6;addx,-120;diffusealpha,1))(subself);
						--self:settext(param[1]);
					end;
				};
				Def.Sound{
					Name="TxtBeep";
					File=THEME:GetPathS("","msg2");
					InitCommand=function(subself)
						self.sound = subself;
					end;
					AudioCommand=function(subself)
						subself:play();
					end;
					OffCommand=function(subself)
						subself:stop();
					end;
					TextboxAnimationFinishedMessageCommand=cmd(playcommand,'Off');
					
				};
				Def.BitmapText{
					Font= font, Name= "vntext", Text= "", 
					InitCommand= function(subself)
						-- note that self refers to the wrapper, subself is the actor.
						self.text_actor= subself
						subself:horizalign(left):vertalign(top):wrapwidthpixels(maxwidth):xy(-SCREEN_CENTER_X+130,-50)
							--:diffuse(clr)
						subself:vertspacing(10);
						--subself:queuecommand("Init2");
					end,
					--Doesn't work
					--[[SetPopupModeCommand=function(subself,pos)
						subself:horizalign('HorizAlign_Center'):vertalign('VertAlign_Middle'):xy(pos.x,pos.y)
					end;]]
					OnCommand= function(subself)
						--subself:queuecommand("Check");
					end,
					CheckCommand= function(subself)
						--Check if line starts with a MessageCommand
						--TODO: Make it so it supports playing a command at any time using tmp_txt = self.text:sub(self.cur_txt, #self.text)?
						local tmp_txt = self.text;
						local skipDraw = false
						local waitBeforeAnim = 0;
						local popupParams = nil;
						--Trace("Checking "..tmp_txt);
						while tmp_txt:sub(1,1) == "/" do --While string has slash at the beginning
							--SCREENMAN:SystemMessage("aaa");
							if string.starts(tmp_txt, "/c[") then
								local cmd_end = string.find(tmp_txt, "%]", 3);
								if not cmd_end then
									tmp_txt = "Bad color code!"
								else
									--Trace("Diffused "..tmp_txt:sub(4,cmd_end-1))
									subself:diffuse(color(tmp_txt:sub(4,cmd_end-1)));
									--SCREENMAN:SystemMessage("diffused "..tmp_txt:sub(3,cmd_end)..", new msg is "..tmp_txt:sub(cmd_end+1, #tmp_txt));
									tmp_txt = tmp_txt:sub(cmd_end+1, #tmp_txt);
								end
							elseif string.starts(tmp_txt, "/cn[") then
								local cmd_end = string.find(tmp_txt, "%]", 3);
								if not cmd_end then
									tmp_txt = "Bad color code!"
								else
									self.name_actor:diffusebottomedge(color(tmp_txt:sub(5,cmd_end-1)));
									tmp_txt = tmp_txt:sub(cmd_end+1, #tmp_txt);
								end
							elseif string.starts(tmp_txt, "/name[") then
								local cmd_end = string.find(tmp_txt, "%]", 7);
								if not cmd_end then
									SCREENMAN:SystemMessage("bad name command!");
								else
									local name = tmp_txt:sub(7,cmd_end-1)
									self.name_actor:settext(name)
									
									if #self.matchedNames > 0 then
										for i,match in ipairs(self.matchedNames) do
											if match==name then
												Trace("Matched portrait "..name.." at idx "..i)
												for portrait,_ in pairs(self.lastPortraitTable) do
													local p = self.portraits[portrait]
													if p.idx==i then
														p.actor:z(11):VN_Undim();
													elseif p.is_active then
														p.actor:z(10):VN_Dim();
													end;
												end;
											end
										end;
									end;
									tmp_txt = tmp_txt:sub(cmd_end+1, #tmp_txt);
								end
							elseif string.starts(tmp_txt, "/mc[") then
								local cmd_end = string.find(tmp_txt, "%]", 4);
								if not cmd_end then
									SCREENMAN:SystemMessage("Bad message command!");
									break
								else
									local command = tmp_txt:sub(5,cmd_end-1)
									local msg = split(",",command)
									--Second argument of Broadcast only takes tables, so shove it in a table.
									--SCREENMAN:SystemMessage(msg[2]);
									if msg[2] then
										MESSAGEMAN:Broadcast(msg[1],{msg[2],msg[3]})
									else
										MESSAGEMAN:Broadcast(msg[1])
									end;
									--SCREENMAN:SystemMessage("Broadcasted "..command..", new msg is "..tmp_txt:sub(cmd_end+1, #tmp_txt));
									--SCREENMAN:SystemMessage("Broadcast "..msg[1]..", "..msg[2]);
									tmp_txt = tmp_txt:sub(cmd_end+1, #tmp_txt);
								end
							--[[elseif string.starts(tmp_txt, "/p[") then
								local cmd_end = string.find(tmp_txt, "%]", 3);
								if not cmd_end then
									SCREENMAN:SystemMessage("Bad portrait command!");
									break
								else
									local command = tmp_txt:sub(4,cmd_end-1)
									Trace(command)
									local a = split(",",command)
									self.portraits[tonumber(a[1])+1]:position_portrait(a[2]=='1',a[3],a[4])
									
									tmp_txt = tmp_txt:sub(cmd_end+1, #tmp_txt);
								end
							elseif string.starts(tmp_txt, "/nop[") then
								local cmd_end = string.find(tmp_txt, "%]", 4);
								if not cmd_end then
									SCREENMAN:SystemMessage("Bad portrait command!");
									break
								else
									local command = tmp_txt:sub(6,cmd_end-1)
									--Trace(command)
									self.portraits[tonumber(command)+1].actor:playcommand("Stop");
									
									tmp_txt = tmp_txt:sub(cmd_end+1, #tmp_txt);
								end]]
							elseif string.starts(tmp_txt, "/spr[") then
								local cmd_end = string.find(tmp_txt, "%]", 4);
								if not cmd_end then
									SCREENMAN:SystemMessage("Bad spr command!");
									break
								else
									local command = tmp_txt:sub(6,cmd_end-1)
									Trace(command)
									local a = split(",",command)
									local val = tonumber(a[1])+1
									
									for _,v in pairs(self.portraits) do
										if v.idx == val then
											--Trace("Set "..v.spr.." to "..a[2])
											v.sprActor:setstate(tonumber(a[2]))
											break
										--[[else
											Trace(v.idx..": "..v.spr)]]
										end
									end;
									--self.portraits[tonumber(a[1])+1].actor:setstate(tonumber(a[2]))
									
									tmp_txt = tmp_txt:sub(cmd_end+1, #tmp_txt);
								end
							elseif string.starts(tmp_txt, "/dim[") then
								local cmd_end = string.find(tmp_txt, "%]", 4);
								if not cmd_end then
									SCREENMAN:SystemMessage("Bad dim command!");
								else
									local val = tonumber(tmp_txt:sub(6,cmd_end-1))+1
									Trace(val)
									--Trace(tmp_txt:sub(6,cmd_end-1))
									for _,v in pairs(self.portraits) do
										if v.idx == val then
											v.actor:VN_Dim();
											break
										--[[else
											Trace(v.idx..": "..v.spr)]]
										end;
									end;
									--Trace(self.portraits[val].actor:GetName())
									
									tmp_txt = tmp_txt:sub(cmd_end+1, #tmp_txt);
								end
							elseif string.starts(tmp_txt, "/undim[") then
								local cmd_end = string.find(tmp_txt, "%]", 4);
								if not cmd_end then
									SCREENMAN:SystemMessage("Bad undim command!");
								else
									--Trace(tmp_txt:sub(8,cmd_end-1))
									local val = tonumber(tmp_txt:sub(8,cmd_end-1))+1
									for _,v in pairs(self.portraits) do
										if v.idx == val then
											v.actor:VN_Undim();
											break
										end;
									end;
									
									tmp_txt = tmp_txt:sub(cmd_end+1, #tmp_txt);
								end
							--Don't undim others
							elseif string.starts(tmp_txt, "/hl[") then
								assert(self.lastPortraitTable,'Hey genius, you need to set portraits before using /hl[].');
								local cmd_end = string.find(tmp_txt, "%]", 4);
								if not cmd_end then
									SCREENMAN:SystemMessage("Bad dim command!");
								else
									local val = tonumber(tmp_txt:sub(5,cmd_end-1))+1
									
									for portrait,_ in pairs(self.lastPortraitTable) do
										local p = self.portraits[portrait]
										if p.idx==val then
											p.actor:z(11):VN_Undim();
										elseif p.is_active then
											p.actor:z(10):VN_Dim();
										end;
									end;
									--[[for i,p in ipairs(self.portraits) do
										if i==val then
											self.portraits[i].actor:VN_Undim();
										elseif self.portraits[i].is_active then
											self.portraits[i].actor:VN_Dim();
										end;
									end;]]
									
									tmp_txt = tmp_txt:sub(cmd_end+1, #tmp_txt);
								end
							elseif string.starts(tmp_txt, "/se[") then
								local cmd_end = string.find(tmp_txt, "%]", 4);
								if not cmd_end then
									SCREENMAN:SystemMessage("Bad se command!");
								else
									local command = tmp_txt:sub(6,cmd_end-1)
									SOUND:PlayOnce(THEME:GetPathS("","StoryMode/"..command));
									
									tmp_txt = tmp_txt:sub(cmd_end+1, #tmp_txt);
								end
							elseif string.starts(tmp_txt, "/gc[") then
								local cmd_end = string.find(tmp_txt, "%]", 5);
								if not cmd_end then
									SCREENMAN:SystemMessage("bad gamecommand!");
								else
									GAMESTATE:ApplyGameCommand(tmp_txt:sub(5,cmd_end-1),GAMESTATE:GetMasterPlayerNumber())
									--[[local commands = split(";",tmp_txt:sub(5,cmd_end-1))
									SCREENMAN:SystemMessage(table_print(commands))
									for _,command in ipairs(commands) do
										GAMESTATE:ApplyGameCommand(command,GAMESTATE:GetMasterPlayerNumber())
									end;]]
									tmp_txt = tmp_txt:sub(cmd_end+1, #tmp_txt);
								end
							elseif string.starts(tmp_txt,"/skip") then
								tmp_txt = tmp_txt:sub(6,#tmp_txt)
								skipDraw = true
							elseif string.starts(tmp_txt,'/bg[') then
								local cmd_end = string.find(tmp_txt, "%]",4);
								local val = tonumber(tmp_txt:sub(5,cmd_end-1))+1
								backgrounds:show(val)
								tmp_txt = tmp_txt:sub(cmd_end+1, #tmp_txt);
								--Trace(tmp_txt)
							elseif string.starts(tmp_txt,'/nobg[') then
								local cmd_end = string.find(tmp_txt, "%]",6);
								local val = tonumber(tmp_txt:sub(7,cmd_end-1))+1
								backgrounds:hide(val)
								tmp_txt = tmp_txt:sub(cmd_end+1, #tmp_txt);
							elseif string.starts(tmp_txt,'/popup[') then
								local cmd_end = string.find(tmp_txt, "%]",7);
								
								local pos = split(",",tmp_txt:sub(8,cmd_end-1))
								popupParams = {x=tonumber(pos[1]),y=tonumber(pos[2])}
								--assert(popupParams.x)
								--assert(popupParams.y);
								
								
								if self.isPopup == false then
									self.bg:queuecommand("Stop");
									self.popup:decelerate(.2):diffusealpha(.8);
									waitBeforeAnim=waitBeforeAnim+0.2
								end;
								
								
								self.popup:xy(popupParams.x,popupParams.y)
								subself:horizalign('HorizAlign_Center'):vertalign('VertAlign_Middle'):xy(popupParams.x,popupParams.y+1)
								
								self.isPopup = true
								
								tmp_txt = tmp_txt:sub(cmd_end+1,#tmp_txt)
							elseif string.starts(tmp_txt,'/noPopup') then
								tmp_txt = tmp_txt:sub(9,#tmp_txt)
								self.popup:queuecommand("Stop");
								self.bg:sleep(0.2):queuecommand("Play");
								subself:playcommand("Init"); --reset position.
								waitBeforeAnim=waitBeforeAnim+0.4
								self.isPopup = false
								
							elseif string.starts(tmp_txt,"/close") then
								tmp_txt = tmp_txt:sub(7,#tmp_txt)
								self.bg:queuecommand("Stop");
								waitBeforeAnim=waitBeforeAnim+0.2
							elseif string.starts(tmp_txt,"/open") then
								tmp_txt = tmp_txt:sub(6,#tmp_txt)
								self.bg:queuecommand("Play");
								waitBeforeAnim=waitBeforeAnim+0.2
							elseif string.starts(tmp_txt,"/stopMusic") then
								tmp_txt = tmp_txt:sub(11,#tmp_txt)
								self.music:RunCommandsOnChildren(stop)
							elseif string.starts(tmp_txt,"/playMusic[") then
								lua.ReportScriptError("playMusic in a message is depreciated. Please use the music opcode.");
								local cmd_end = string.find(tmp_txt, "%]", 11);
								if not cmd_end then
									SCREENMAN:SystemMessage("bad playMusic command!");
								else
									Trace(table_print(self.music))
									--assert(self.music,"self.music is missing. Cannot play music.")
									--TODO: This won't work because the uncompiled ActorFrame is being set to self.music
									self.music:GetChild(tmp_txt:sub(11,cmd_end-1)):play();
									tmp_txt = tmp_txt:sub(cmd_end+1, #tmp_txt);
								end
							else
								lua.ReportScriptError("Unknown command used in VNScript: "..tmp_txt.." | Any more commands will be ignored.")
								break
							end;
						end;
						self.text = tmp_txt
						subself:settext(self.text);
						
						--Trace("Ended with "..self.text);
						if self.isPopup then
							waitBeforeAnim=waitBeforeAnim+.2;
							if popupParams == nil then --If position didn't change then resize box insted of zooming from 0
								self.popup:decelerate(.2):zoomtowidth(subself:GetWidth()+10):zoomtoheight(subself:GetHeight()+10);
							else
								self.popup:zoomto(0,0):decelerate(.2):zoomtowidth(subself:GetWidth()+10):zoomtoheight(subself:GetHeight()+10);
							end;
						end;
						
						if not skipDraw then
							--subself:playcommand("Play");
							subself:cropright(1)
							if waitBeforeAnim > 0 then
								subself:sleep(waitBeforeAnim);
								self.sound:sleep(waitBeforeAnim);
							end;
							subself:linear(1/self.spd*(#self.text)):cropright(0):queuemessage("TextboxAnimationFinished");
							self.sound:queuecommand("Audio");
						else
							subself:cropright(0)
							MESSAGEMAN:Broadcast("TextboxAnimationFinished");
							SOUND:PlayOnce(THEME:GetPathS("","msg1"));
							--self:skip();
						end;
					end,
				}
			}
        end,
		advance= function(self)
			self.curIndex = self.curIndex+1
			while true do
				--assert(self.msgTable[self.curIndex],"There is no opcode located at "..self.curIndex)
				
				--Normally the interpreter would close if there's a message opcode at the end because the input handler checks it (why haven't I fixed that already?).
				--But if there's non-message related stuff it keeps going
				if self.curIndex > #self.msgTable then
					return false
				end;
				
				local opcode = self.msgTable[self.curIndex][1]
				Trace(opcode)
				--Trace(self.curIndex);
				if opcode == "msg" then
					self.cur_len= 0
					self.text = self.msgTable[self.curIndex][2]
					--self.text_actor:queuecommand("Check")
					break
				elseif opcode == "fmsg" then
					self.cur_len= 0
					self.text = self.msgTable[self.curIndex][2]()
					--self.text_actor:queuecommand("Check")
					break
				elseif opcode == "func" then
					self.msgTable[self.curIndex][2]()
				elseif opcode == "choice" then
					ChoiceTable = {Result=1,Finished=false}
					assert(self.msgTable[self.curIndex][2],"Choice table is invalid.")
					ChoiceTable.Choices = self.msgTable[self.curIndex][2]
					assert(ChoiceTable.Choices)
					Trace("Loaded choices "..table_print(ChoiceTable.Choices,0))
				elseif opcode == "exit" then
					return false;
				--Jumps
				elseif opcode == "jmp" then
					self.curIndex = self.curIndex+self.msgTable[self.curIndex][2]-1
				elseif opcode == "condJmpSS" then
					Trace(table_print(self.selfSwitches))
					Trace(table_print(self.msgTable[self.curIndex]))
					if self.selfSwitches[self.msgTable[self.curIndex][3]] == true then
						--Subtract 1 to account for advance advancing one step, since we want to start on whatever it jumps to
						self.curIndex = self.curIndex+self.msgTable[self.curIndex][2]-1
						Trace("Jumped to index "..self.curIndex+1)
						--Trace(table_print(self.msgTable[self.curIndex+1]))
					end
				elseif opcode == "condJmp" then
					if self.msgTable[self.curIndex][3]() == true then
						--Subtract 1 to account for advance advancing one step, since we want to start on whatever it jumps to
						self.curIndex = self.curIndex+self.msgTable[self.curIndex][2]-1
						Trace("Jumped to index "..self.curIndex)
					end
				--Long Jumps
				elseif opcode == "LongJmp" then
					self.curIndex = self.msgTable[self.curIndex][2]-1
				elseif opcode == "LongCondJmpSS" then
					if self.selfSwitches[self.msgTable[self.curIndex][3]] == true then
						self.curIndex = self.msgTable[self.curIndex][2]-1
						Trace("Jumped to index "..self.curIndex+1)
					end
				elseif opcode == "LongCondJmp" then
					if self.msgTable[self.curIndex][3]() == true then
						self.curIndex = self.msgTable[self.curIndex][2]-1
						Trace("Jumped to index "..self.curIndex)
					end
				
				elseif opcode == "selfSwitch" then
					assert(self.selfSwitches,"Attempted to use a self switch command when there's no switches set. Did you set noFlags=true in the event?")
					self.selfSwitches[self.msgTable[self.curIndex][2]] = self.msgTable[self.curIndex][3]
				elseif opcode == "flag" then
					--Matches 'data' table in StoryModeSave
					local o = self.msgTable[self.curIndex]
					if saveData then
						saveData[o[2]][o[3]][o[4]]=o[5]
					else
						lua.ReportScriptError("Tried to set a savedata flag, but there's no savedata loaded!");
					end;
				elseif opcode == "song" then
					local o = self.msgTable[self.curIndex]
					playSong(o[2],o[3],o[4])
					
					--Don't bother freezing context if this is the last command.
					if self.curIndex < #self.msgTable then
						MESSAGEMAN:Broadcast("FreezeContext");
					else
						setenv("nextPart",tonumber(getenv('nextPart'))+1);
					end;
				elseif opcode == "screen" then
					MESSAGEMAN:Broadcast("FreezeContext");
					SCREENMAN:GetTopScreen():SetNextScreenName(self.msgTable[self.curIndex][2]);
					SCREENMAN:GetTopScreen():StartTransitioningScreen("SM_GoToNextScreen");
				elseif opcode == "freezeContext" then
					MESSAGEMAN:Broadcast("FreezeContext");
					return; --We don't want to progress any more.
				elseif opcode == "portrait" or opcode=="portraits" then
				
					--[[ Map portraits in the new message to 'real' positions.
					     ex. {'portrait',"Marisa","Alice","Patchouli"} needs to get mapped to new_table,
					     new_table is {"Marisa","Alice","Patchouli"}
					  ]]
					local new_table = {};
					for i=2,#self.msgTable[self.curIndex] do
						new_table[#new_table+1]=self.msgTable[self.curIndex][i]
					end;
					--Trace(table_print(new_table))
					local relation = self.lastPortraitTable and table.shallowcopy(self.lastPortraitTable) or {}
					self.lastPortraitTable={} --Wipe table so there aren't a bunch of indexed 'false' portraits
					
					local numPortraits = 0
					for pos,portrait in pairs(new_table) do
						numPortraits=numPortraits+1
						if type(portrait)=='table' then
							--[[
							To use for next iteration, self.lastPortraitTable will get copied to relation. Anything that has a new position
							will get the false value in relation overwritten. If any portrait that existed in lastPortraitTable doesn't exist
							in this one, it will still have the value of false.
							
							Remember, the structure of the portrait opcode is {name,isMasked,offset}
							]]
							
							self.lastPortraitTable[portrait[1]]=false
							relation[portrait[1]]={pos,portrait[2],portrait[3]}
						else
							self.lastPortraitTable[portrait]=false
							relation[portrait]={pos,false,0} --pos,isMasked,offset
						end;
					end;
					
					--position_portrait = function(self,idx,isMasked,offset,numPortraits)
					--Trace(table_print(relation))
					for name,pStruct in pairs(relation) do
						assert(self.portraits[name],"A portrait by the name of "..name.." does not exist, either you made a typo or you forgot to put it in LoadImages.");
						if not pStruct then
							self.portraits[name].actor:playcommand("Stop")
						else
							--Pos,isMasked,offset
							self.portraits[name]:position_portrait(pStruct[1],pStruct[2],pStruct[3],numPortraits)
						end;
					end;
				elseif opcode == "match_names" then
					local new_table = {};
					for i=2,#self.msgTable[self.curIndex] do
						new_table[#new_table+1]=self.msgTable[self.curIndex][i]
					end;
					self.matchedNames=new_table;
				elseif opcode == "music" then
					Trace(table_print(self.music))
					assert(self.music.frame,"self.music is missing. Cannot play music.")
					--TODO: This won't work because the uncompiled ActorFrame is being set to self.music
					for actorName, actor in pairs(self.music.frame:GetChildren()) do
						if actorName == self.msgTable[self.curIndex][2] then
							actor:play();
						else
							actor:stop();
						end;
					end;
				elseif opcode == "nop" then
					--Do nothing.
				else
					Trace("Ignoring unknown opcode "..opcode)
				end;
				self.curIndex = self.curIndex+1
				
			end;
			Trace(self.text)
			lua.Flush();
			self.text_actor:settext(""):playcommand("Check");
		end,
        skip= function(self)
        	self.sound:stop();
            self.text_actor:finishtweening():queuemessage("TextboxAnimationFinished")
            --self.text_actor:settext(self.text)
            --self.cur_len= #self.text
        end,
        is_finished= function(self)
            return self.text_actor:GetTweenTimeLeft() == 0
            --return self.cur_len == #self.text;
        end,
		no_more_text=function(self)
			return #self.msgTable <= self.curIndex
		end,
		--[[
		selfSwitches probably shouldn't be passed in but it was the only way I could think of of accessing them
		The global saveData table is already passed in as reference so this shouldn't REALLY be necessary...
		But the NPC message table and save data are separate tables so there wouldn't be any way of getting to
		the selfSwitches otherwise.
		]]
        set_new_table= function(self, msgTable, selfSwitches, curIndex)
        	assert(msgTable);
        	--assert(selfSwitches);
        	self.msgTable = msgTable
        	self.curIndex = curIndex or 0
        	self.selfSwitches = selfSwitches
            self.text_actor:settext("");
            self.name_actor:settext("");
            --self.cur_len= 0
            
            self:advance()
        end,
        --Return context so the game can save it and return to this later
        get_context=function(self)
        	return {self.msgTable, self.curIndex, self.selfSwitches}
        end;
}}

	return setmetatable({saveData=saveData,portraits=portraits,music=sound,backgrounds=backgrounds}, vntext_mt)

	

end;
